broadqq <-function(pvals, title) {
observed <- sort(pvals) 
lobs <- -(log10(observed))
expected <- c(1:length(observed))
lexp <- -(log10(expected / (length(expected)+1)))
plot(c(0,7), c(0,7), col="red", lwd=3, type="l", xlab="Expected (-logP)", ylab="Observed (-logP)", xlim=c(0,max(lobs)), ylim=c(0,max(lobs)), las=1, xaxs="i", yaxs="i", bty="l", main = title)
points(lexp, lobs, pch=23, cex=.4, bg="black") }

jpeg("qqplot_compare.jpeg", height=1000, width=500) 
par(mfrow=c(2,1))
aff_unadj<-read.table("unadj.assoc.logistic", header=TRUE) 
aff_unadj.add.p<-aff_unadj[aff_unadj$TEST==c("ADD"),]$P 
broadqq(aff_unadj.add.p,"Some Trait Unadjusted") 
aff_C1C2<-read.table("PC1-PC2.assoc.logistic", header=TRUE) 
aff_C1C2.add.p<-aff_C1C2[aff_C1C2$TEST==c("ADD"),]$P 
broadqq(aff_C1C2.add.p, "Some Trait Adjusted for PC1 and PC2") 
dev.off()
