# Simple logistic regression wrapper

logistic <- function(formula, weights) {
  if (missing(weights))
    res <- glm(formula, family=binomial)
  else {
    wt <- weights
    res <- glm(formula, family=binomial, weights=wt)
  }
  class(res) <- c("logistic", "glm", "lm")
  res$call$formula <- formula
  res
}

print.logistic <- function(x, ...) {
  sx <- summary(x)
  beta <- sx$coefficients
  intcp <- match("(Intercept)", rownames(beta))
  if (!is.na(intcp)) {
    beta <- beta[-intcp,,drop=FALSE]
  }
  or <- matrix(nrow=nrow(beta), ncol=5)
  rownames(or) <- rownames(beta)
  colnames(or) <- c("OR", "Lower",
                    "Upper", "z-test", "P-value")
  or[,1] <- exp(beta[,1])
  or[,2] <- exp(beta[,1]-1.96*beta[,2])
  or[,3] <- exp(beta[,1]+1.96*beta[,2])
  or[,4] <- beta[,3]
  or[,5] <- beta[,4]
  cat("Logistic regression: ", deparse(sx$call$formula), "\n\n")
  cat("Odds ratios (1 unit change), lower and upper confidence limits, and tests:\n\n")
  print(or)
}
